
package Transformation;

import java.util.ArrayList;

/**
 *	Describes an SubjectClass object which is the subject in CIDOC triples.
 *  @author Koutraki Maria (kutraki@ics.forth.gr)
 */
public class SubjectClass {

    private String entity;
    private String uriFunctionName;
    private ArrayList<String> uriFunctionArguments; /*uriFunctionArguments is a list of arguments for the URI functions. */
    
    public SubjectClass(String entity, String uriFunctionName, ArrayList uriFunctionArguments){
        this.entity = entity;
        this.uriFunctionName = uriFunctionName;
        this.uriFunctionArguments = uriFunctionArguments;
    }
    
    public String getEntity(){
        return entity;
    }


    public String getUriFunctionName(){
        return uriFunctionName;
    }

    public ArrayList getUriFunctionArguments(){
        return uriFunctionArguments;
    }
}
